<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TWorkFlowsRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_work_flows:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_work_flows:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TWorkFlowsRepository::class)
 */

class TWorkFlows
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_work_flows:read", "t_work_flows:write", "t_work_flow_stages:read" })
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_work_flows:read", "t_work_flows:write", "t_work_flow_stages:read" })
     */
    private $name;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_work_flows:read", "t_work_flows:write" })
     */
    private $status;

    /**
     * @ORM\OneToMany(targetEntity=TWorkFlowStages::class, mappedBy="workflow")
     * @Groups({ "t_work_flows:read", "t_work_flows:write" })
     */
    private $tWorkFlowStages;

    public function __construct()
    {
        $this->tWorkFlowStages = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @return Collection|TWorkFlowStages[]
     */
    public function getTWorkFlowStages(): Collection
    {
        return $this->tWorkFlowStages;
    }

    public function addTWorkFlowStage(TWorkFlowStages $tWorkFlowStage): self
    {
        if (!$this->tWorkFlowStages->contains($tWorkFlowStage)) {
            $this->tWorkFlowStages[] = $tWorkFlowStage;
            $tWorkFlowStage->setWorkflow($this);
        }

        return $this;
    }

    public function removeTWorkFlowStage(TWorkFlowStages $tWorkFlowStage): self
    {
        if ($this->tWorkFlowStages->removeElement($tWorkFlowStage)) {
            // set the owning side to null (unless already changed)
            if ($tWorkFlowStage->getWorkflow() === $this) {
                $tWorkFlowStage->setWorkflow(null);
            }
        }

        return $this;
    }
}
