<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TSectorPrioritiesRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_sector_priorities:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_sector_priorities:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "sector": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TSectorPrioritiesRepository::class)
 */

class TSectorPriorities
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_sector_priorities:read", "t_sector_priorities:write", "t_sector_strategies:read", "t_sector_objectives:read", "t_cidps:read" })
     */
    private $id;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({ "t_sector_priorities:read", "t_sector_priorities:write", "t_sector_strategies:read", "t_sector_objectives:read", "t_cidps:read" })
     */
    private $name;

    /**
     * @ORM\OneToMany(targetEntity=TSectorStrategies::class, mappedBy="sectorPriority")
     * @Groups({ "t_sector_priorities:read", "t_sector_priorities:write" })
     */
    private $tSectorStrategies;

    /**
     * @ORM\OneToMany(targetEntity=TSectorObjectives::class, mappedBy="sectorPriority")
     * @Groups({ "t_sector_priorities:read", "t_sector_priorities:write" })
     */
    private $tSectorObjectives;

    /**
     * @ORM\OneToMany(targetEntity=TCidps::class, mappedBy="programme")
     * @Groups({ "t_sector_priorities:read", "t_sector_priorities:write" })
     */
    private $tCidps;

    /**
     * @ORM\ManyToOne(targetEntity=TCountySectors::class, inversedBy="tSectorPriorities")
     * @Groups({ "t_sector_priorities:read", "t_sector_priorities:write" })
     */
    private $sector;

    public function __construct()
    {
        $this->tSectorStrategies = new ArrayCollection();
        $this->tSectorObjectives = new ArrayCollection();
        $this->tCidps = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): self
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return Collection|TSectorStrategies[]
     */
    public function getTSectorStrategies(): Collection
    {
        return $this->tSectorStrategies;
    }

    public function addTSectorStrategy(TSectorStrategies $tSectorStrategy): self
    {
        if (!$this->tSectorStrategies->contains($tSectorStrategy)) {
            $this->tSectorStrategies[] = $tSectorStrategy;
            $tSectorStrategy->setSectorPriority($this);
        }

        return $this;
    }

    public function removeTSectorStrategy(TSectorStrategies $tSectorStrategy): self
    {
        if ($this->tSectorStrategies->removeElement($tSectorStrategy)) {
            // set the owning side to null (unless already changed)
            if ($tSectorStrategy->getSectorPriority() === $this) {
                $tSectorStrategy->setSectorPriority(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TSectorObjectives[]
     */
    public function getTSectorObjectives(): Collection
    {
        return $this->tSectorObjectives;
    }

    public function addTSectorObjective(TSectorObjectives $tSectorObjective): self
    {
        if (!$this->tSectorObjectives->contains($tSectorObjective)) {
            $this->tSectorObjectives[] = $tSectorObjective;
            $tSectorObjective->setSectorPriority($this);
        }

        return $this;
    }

    public function removeTSectorObjective(TSectorObjectives $tSectorObjective): self
    {
        if ($this->tSectorObjectives->removeElement($tSectorObjective)) {
            // set the owning side to null (unless already changed)
            if ($tSectorObjective->getSectorPriority() === $this) {
                $tSectorObjective->setSectorPriority(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TCidps[]
     */
    public function getTCidps(): Collection
    {
        return $this->tCidps;
    }

    public function addTCidp(TCidps $tCidp): self
    {
        if (!$this->tCidps->contains($tCidp)) {
            $this->tCidps[] = $tCidp;
            $tCidp->setProgramme($this);
        }

        return $this;
    }

    public function removeTCidp(TCidps $tCidp): self
    {
        if ($this->tCidps->removeElement($tCidp)) {
            // set the owning side to null (unless already changed)
            if ($tCidp->getProgramme() === $this) {
                $tCidp->setProgramme(null);
            }
        }

        return $this;
    }

    public function getSector(): ?TCountySectors
    {
        return $this->sector;
    }

    public function setSector(?TCountySectors $sector): self
    {
        $this->sector = $sector;

        return $this;
    }
}
