<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TPcsRepository;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_pcs:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_pcs:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "governorWithCec": "exact", "cecSignsOwnPc": "exact", "coSignsOwnPc": "exact", "dirSignsOwnPc": "exact", "progressStatus": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TPcsRepository::class)
 */

class TPcs
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_pcs:read", "t_pcs:write" })
     */
    private $id;

    /**
     * @ORM\Column(type="date")
     * @Groups({ "t_pcs:read", "t_pcs:write" })
     */
    private $creationDate;

    /**
     * @ORM\OneToMany(targetEntity=TPcMatrix::class, mappedBy="pc")
     * @Groups({ "t_pcs:read", "t_pcs:write" })
     */
    private $tPcMatrices;

    /**
     * @ORM\ManyToOne(targetEntity=TWorkFlowStages::class, inversedBy="tPcs")
     * @Groups({ "t_pcs:read", "t_pcs:write" })
     */
    private $workflowStage;

    /**
     * @ORM\ManyToOne(targetEntity=TGovernors::class, inversedBy="tPcs")
     * @Groups({ "t_pcs:read", "t_pcs:write" })
     */
    private $governorWithCec;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({ "t_pcs:read", "t_pcs:write" })
     */
    private $governorWithCecSignDate;

    /**
     * @ORM\ManyToOne(targetEntity=TCecs::class, inversedBy="tPcs")
     * @Groups({ "t_pcs:read", "t_pcs:write" })
     */
    private $cecSignsOwnPc;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({ "t_pcs:read", "t_pcs:write" })
     */
    private $cecSignsOwnPcSignDate;

    /**
     * @ORM\ManyToOne(targetEntity=TCountySecretary::class, inversedBy="tPcsCecPc")
     * @Groups({ "t_pcs:read", "t_pcs:write" })
     */
    private $countySecWitnessCecPc;

    /**
     * @ORM\ManyToOne(targetEntity=TCecs::class, inversedBy="cecWithCo")
     * @Groups({ "t_pcs:read", "t_pcs:write" })
     */
    private $cecWithCo;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({ "t_pcs:read", "t_pcs:write" })
     */
    private $cecWithCoSignDate;

    /**
     * @ORM\ManyToOne(targetEntity=TCos::class, inversedBy="tPcs")
     * @Groups({ "t_pcs:read", "t_pcs:write" })
     */
    private $coSignsOwnPc;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({ "t_pcs:read", "t_pcs:write" })
     */
    private $coSignsOwnPcDate;

    /**
     * @ORM\ManyToOne(targetEntity=TCountySecretary::class, inversedBy="tPcs")
     * @Groups({ "t_pcs:read", "t_pcs:write" })
     */
    private $countySecWitnessCoPc;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({ "t_pcs:read", "t_pcs:write" })
     */
    private $countySecWitnessCoPcDate;

    /**
     * @ORM\ManyToOne(targetEntity=TCos::class, inversedBy="coWithDir")
     * @Groups({ "t_pcs:read", "t_pcs:write" })
     */
    private $coWithDir;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({ "t_pcs:read", "t_pcs:write" })
     */
    private $coWithDirDate;

    /**
     * @ORM\ManyToOne(targetEntity=TDirectors::class, inversedBy="tPcs")
     * @Groups({ "t_pcs:read", "t_pcs:write" })
     */
    private $dirSignsOwnPc;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({ "t_pcs:read", "t_pcs:write" })
     */
    private $dirSignsOwnPcDate;

    /**
     * @ORM\ManyToOne(targetEntity=TCecs::class, inversedBy="cecWitnessDirPc")
     * @Groups({ "t_pcs:read", "t_pcs:write" })
     */
    private $cecWitnessDirPc;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({ "t_pcs:read", "t_pcs:write" })
     */
    private $cecWitnessDirPcDate;

    /**
     * @ORM\OneToMany(targetEntity=TStrategicObjectives::class, mappedBy="pc")
     */
    private $tStrategicObjectives;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({ "t_pcs:read", "t_pcs:write" })
     */
    private $startDate;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({ "t_pcs:read", "t_pcs:write" })
     */
    private $endDate;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_pcs:read", "t_pcs:write" })
     */
    private $progressStatus;

    public function __construct()
    {
        $this->tPcMatrices = new ArrayCollection();
        $this->tStrategicObjectives = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getCreationDate(): ?\DateTimeInterface
    {
        return $this->creationDate;
    }

    public function setCreationDate(\DateTimeInterface $creationDate): self
    {
        $this->creationDate = $creationDate;

        return $this;
    }    
    

    /**
     * @return Collection|TPcMatrix[]
     */
    public function getTPcMatrices(): Collection
    {
        return $this->tPcMatrices;
    }

    public function addTPcMatrix(TPcMatrix $tPcMatrix): self
    {
        if (!$this->tPcMatrices->contains($tPcMatrix)) {
            $this->tPcMatrices[] = $tPcMatrix;
            $tPcMatrix->setPc($this);
        }

        return $this;
    }

    public function removeTPcMatrix(TPcMatrix $tPcMatrix): self
    {
        if ($this->tPcMatrices->removeElement($tPcMatrix)) {
            // set the owning side to null (unless already changed)
            if ($tPcMatrix->getPc() === $this) {
                $tPcMatrix->setPc(null);
            }
        }

        return $this;
    }

    public function getWorkflowStage(): ?TWorkflowStages
    {
        return $this->workflowStage;
    }

    public function setWorkflowStage(?TWorkflowStages $workflowStage): self
    {
        $this->workflowStage = $workflowStage;

        return $this;
    }

    public function getGovernorWithCec(): ?TGovernors
    {
        return $this->governorWithCec;
    }

    public function setGovernorWithCec(?TGovernors $governorWithCec): self
    {
        $this->governorWithCec = $governorWithCec;

        return $this;
    }

    public function getGovernorWithCecSignDate(): ?\DateTimeInterface
    {
        return $this->governorWithCecSignDate;
    }

    public function setGovernorWithCecSignDate(?\DateTimeInterface $governorWithCecSignDate): self
    {
        $this->governorWithCecSignDate = $governorWithCecSignDate;

        return $this;
    }

    public function getCecSignsOwnPc(): ?TCecs
    {
        return $this->cecSignsOwnPc;
    }

    public function setCecSignsOwnPc(?TCecs $cecSignsOwnPc): self
    {
        $this->cecSignsOwnPc = $cecSignsOwnPc;

        return $this;
    }

    public function getCecSignsOwnPcSignDate(): ?\DateTimeInterface
    {
        return $this->cecSignsOwnPcSignDate;
    }

    public function setCecSignsOwnPcSignDate(\DateTimeInterface $cecSignsOwnPcSignDate): self
    {
        $this->cecSignsOwnPcSignDate = $cecSignsOwnPcSignDate;

        return $this;
    }

    public function getCountySecWitnessCecPc(): ?TCountySecretary
    {
        return $this->countySecWitnessCecPc;
    }

    public function setCountySecWitnessCecPc(?TCountySecretary $countySecWitnessCecPc): self
    {
        $this->countySecWitnessCecPc = $countySecWitnessCecPc;

        return $this;
    }

    public function getCecWithCo(): ?TCecs
    {
        return $this->cecWithCo;
    }

    public function setCecWithCo(?TCecs $cecWithCo): self
    {
        $this->cecWithCo = $cecWithCo;

        return $this;
    }

    public function getCecWithCoSignDate(): ?\DateTimeInterface
    {
        return $this->cecWithCoSignDate;
    }

    public function setCecWithCoSignDate(?\DateTimeInterface $cecWithCoSignDate): self
    {
        $this->cecWithCoSignDate = $cecWithCoSignDate;

        return $this;
    }

    public function getCoSignsOwnPc(): ?TCos
    {
        return $this->coSignsOwnPc;
    }

    public function setCoSignsOwnPc(?TCos $coSignsOwnPc): self
    {
        $this->coSignsOwnPc = $coSignsOwnPc;

        return $this;
    }

    public function getCoSignsOwnPcDate(): ?\DateTimeInterface
    {
        return $this->coSignsOwnPcDate;
    }

    public function setCoSignsOwnPcDate(?\DateTimeInterface $coSignsOwnPcDate): self
    {
        $this->coSignsOwnPcDate = $coSignsOwnPcDate;

        return $this;
    }

    public function getCountySecWitnessCoPc(): ?TCountySecretary
    {
        return $this->countySecWitnessCoPc;
    }

    public function setCountySecWitnessCoPc(?TCountySecretary $countySecWitnessCoPc): self
    {
        $this->countySecWitnessCoPc = $countySecWitnessCoPc;

        return $this;
    }

    public function getCountySecWitnessCoPcDate(): ?\DateTimeInterface
    {
        return $this->countySecWitnessCoPcDate;
    }

    public function setCountySecWitnessCoPcDate(?\DateTimeInterface $countySecWitnessCoPcDate): self
    {
        $this->countySecWitnessCoPcDate = $countySecWitnessCoPcDate;

        return $this;
    }

    public function getCoWithDir(): ?TCos
    {
        return $this->coWithDir;
    }

    public function setCoWithDir(?TCos $coWithDir): self
    {
        $this->coWithDir = $coWithDir;

        return $this;
    }

    public function getCoWithDirDate(): ?\DateTimeInterface
    {
        return $this->coWithDirDate;
    }

    public function setCoWithDirDate(?\DateTimeInterface $coWithDirDate): self
    {
        $this->coWithDirDate = $coWithDirDate;

        return $this;
    }

    public function getDirSignsOwnPc(): ?TDirectors
    {
        return $this->dirSignsOwnPc;
    }

    public function setDirSignsOwnPc(?TDirectors $dirSignsOwnPc): self
    {
        $this->dirSignsOwnPc = $dirSignsOwnPc;

        return $this;
    }

    public function getDirSignsOwnPcDate(): ?\DateTimeInterface
    {
        return $this->dirSignsOwnPcDate;
    }

    public function setDirSignsOwnPcDate(?\DateTimeInterface $dirSignsOwnPcDate): self
    {
        $this->dirSignsOwnPcDate = $dirSignsOwnPcDate;

        return $this;
    }

    public function getCecWitnessDirPc(): ?TCecs
    {
        return $this->cecWitnessDirPc;
    }

    public function setCecWitnessDirPc(?TCecs $cecWitnessDirPc): self
    {
        $this->cecWitnessDirPc = $cecWitnessDirPc;

        return $this;
    }

    public function getCecWitnessDirPcDate(): ?\DateTimeInterface
    {
        return $this->cecWitnessDirPcDate;
    }

    public function setCecWitnessDirPcDate(?\DateTimeInterface $cecWitnessDirPcDate): self
    {
        $this->cecWitnessDirPcDate = $cecWitnessDirPcDate;

        return $this;
    }

    /**
     * @return Collection|TStrategicObjectives[]
     */
    public function getTStrategicObjectives(): Collection
    {
        return $this->tStrategicObjectives;
    }

    public function addTStrategicObjective(TStrategicObjectives $tStrategicObjective): self
    {
        if (!$this->tStrategicObjectives->contains($tStrategicObjective)) {
            $this->tStrategicObjectives[] = $tStrategicObjective;
            $tStrategicObjective->setPc($this);
        }

        return $this;
    }

    public function removeTStrategicObjective(TStrategicObjectives $tStrategicObjective): self
    {
        if ($this->tStrategicObjectives->removeElement($tStrategicObjective)) {
            // set the owning side to null (unless already changed)
            if ($tStrategicObjective->getPc() === $this) {
                $tStrategicObjective->setPc(null);
            }
        }

        return $this;
    }

    public function getStartDate(): ?\DateTimeInterface
    {
        return $this->startDate;
    }

    public function setStartDate(?\DateTimeInterface $startDate): self
    {
        $this->startDate = $startDate;

        return $this;
    }

    public function getEndDate(): ?\DateTimeInterface
    {
        return $this->endDate;
    }

    public function setEndDate(?\DateTimeInterface $endDate): self
    {
        $this->endDate = $endDate;

        return $this;
    }

    public function getProgressStatus(): ?string
    {
        return $this->progressStatus;
    }

    public function setProgressStatus(?string $progressStatus): self
    {
        $this->progressStatus = $progressStatus;

        return $this;
    }


}
