<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use App\Repository\TGroupsRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_groups:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_groups:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "type": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TGroupsRepository::class)
 */
class TGroups
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $groupName;

    /**
     * @ORM\Column(type="string", length=255)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $status;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $type;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $dashboarMain;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $dashboardHome;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $dashboardGraphical;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $dashboardsMaps;

    public function __construct()
    {

    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getGroupName(): ?string
    {
        return $this->groupName;
    }

    public function setGroupName(string $groupName): self
    {
        $this->groupName = $groupName;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(string $status): self
    {
        $this->status = $status;

        return $this;
    }

    public function getType(): ?string
    {
        return $this->type;
    }

    public function setType(?string $type): self
    {
        $this->type = $type;

        return $this;
    }

    public function getDashboarMain(): ?bool
    {
        return $this->dashboarMain;
    }

    public function setDashboarMain(?bool $dashboarMain): self
    {
        $this->dashboarMain = $dashboarMain;

        return $this;
    }

    public function getDashboardHome(): ?bool
    {
        return $this->dashboardHome;
    }

    public function setDashboardHome(?bool $dashboardHome): self
    {
        $this->dashboardHome = $dashboardHome;

        return $this;
    }

    public function getDashboardGraphical(): ?bool
    {
        return $this->dashboardGraphical;
    }

    public function setDashboardGraphical(?bool $dashboardGraphical): self
    {
        $this->dashboardGraphical = $dashboardGraphical;

        return $this;
    }

    public function getDashboardsMaps(): ?bool
    {
        return $this->dashboardsMaps;
    }

    public function setDashboardsMaps(?bool $dashboardsMaps): self
    {
        $this->dashboardsMaps = $dashboardsMaps;

        return $this;
    }


}
