<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TFinancialYearsRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_financial_years:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_financial_years:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "status": "exact", "currentYear": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TFinancialYearsRepository::class)
 */

class TFinancialYears
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_financial_years:read", "t_financial_years:write", "t_sector_objectives:read", "t_directorate_objectives:read", "t_county_sectors_adp_projects:read", "t_county_departments_adp_projects:read", "t_directorates_adp_projects:read" })
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_financial_years:read", "t_financial_years:write", "t_county_sectors_adp_projects:read", "t_county_departments_adp_projects:read", "t_directorates_adp_projects:read" })
     */
    private $name;

    /**
     * @ORM\Column(type="string", length=15, nullable=true)
     * @Groups({ "t_financial_years:read", "t_financial_years:write" })
     */
    private $status;

    /**
     * @ORM\Column(type="string", length=15, nullable=true)
     * @Groups({ "t_financial_years:read", "t_financial_years:write" })
     */
    private $currentYear;

    
    /**
     * @ORM\OneToMany(targetEntity=TSectorObjectives::class, mappedBy="financialYear")
     * @Groups({ "t_financial_years:read", "t_financial_years:write" })
     */
    private $tSectorObjectives;

    /**
     * @ORM\OneToMany(targetEntity=TDirectorateObjectives::class, mappedBy="financialYear")
     * @Groups({ "t_financial_years:read", "t_financial_years:write" })
     */
    private $tDirectorateObjectives;

    /**
     * @ORM\OneToMany(targetEntity=TMilestones::class, mappedBy="financialYear")
     * @Groups({ "t_financial_years:read", "t_financial_years:write" })
     */
    private $tMilestones;

    /**
     * @ORM\OneToMany(targetEntity=TAppraisals::class, mappedBy="financialYear")
     */
    private $tAppraisals;

    /**
     * @ORM\OneToMany(targetEntity=TCountySectorsAdpProjects::class, mappedBy="financialYear")
     */
    private $tCountySectorsAdpProjects;

    /**
     * @ORM\OneToMany(targetEntity=TCountyDepartmentsAdpProjects::class, mappedBy="financialYear")
     */
    private $tCountyDepartmentsAdpProjects;

    public function __construct()
    {
        $this->tCountyObjectives = new ArrayCollection();
        $this->tSectorObjectives = new ArrayCollection();
        $this->tDirectorateObjectives = new ArrayCollection();
        $this->tMilestones = new ArrayCollection();
        $this->tAppraisals = new ArrayCollection();
        $this->tCountySectorsAdpProjects = new ArrayCollection();
        $this->tCountyDepartmentsAdpProjects = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }

    public function getCurrentYear(): ?string
    {
        return $this->currentYear;
    }

    public function setCurrentYear(?string $currentYear): self
    {
        $this->currentYear = $currentYear;

        return $this;
    }

    /**
     * @return Collection|TCountyObjectives[]
     */
    public function getTCountyObjectives(): Collection
    {
        return $this->tCountyObjectives;
    }

    public function addTCountyObjective(TCountyObjectives $tCountyObjective): self
    {
        if (!$this->tCountyObjectives->contains($tCountyObjective)) {
            $this->tCountyObjectives[] = $tCountyObjective;
            $tCountyObjective->setFinancialYear($this);
        }

        return $this;
    }

    public function removeTCountyObjective(TCountyObjectives $tCountyObjective): self
    {
        if ($this->tCountyObjectives->removeElement($tCountyObjective)) {
            // set the owning side to null (unless already changed)
            if ($tCountyObjective->getFinancialYear() === $this) {
                $tCountyObjective->setFinancialYear(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TSectorObjectives[]
     */
    public function getTSectorObjectives(): Collection
    {
        return $this->tSectorObjectives;
    }

    public function addTSectorObjective(TSectorObjectives $tSectorObjective): self
    {
        if (!$this->tSectorObjectives->contains($tSectorObjective)) {
            $this->tSectorObjectives[] = $tSectorObjective;
            $tSectorObjective->setFinancialYear($this);
        }

        return $this;
    }

    public function removeTSectorObjective(TSectorObjectives $tSectorObjective): self
    {
        if ($this->tSectorObjectives->removeElement($tSectorObjective)) {
            // set the owning side to null (unless already changed)
            if ($tSectorObjective->getFinancialYear() === $this) {
                $tSectorObjective->setFinancialYear(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TDirectorateObjectives[]
     */
    public function getTDirectorateObjectives(): Collection
    {
        return $this->tDirectorateObjectives;
    }

    public function addTDirectorateObjective(TDirectorateObjectives $tDirectorateObjective): self
    {
        if (!$this->tDirectorateObjectives->contains($tDirectorateObjective)) {
            $this->tDirectorateObjectives[] = $tDirectorateObjective;
            $tDirectorateObjective->setFinancialYear($this);
        }

        return $this;
    }

    public function removeTDirectorateObjective(TDirectorateObjectives $tDirectorateObjective): self
    {
        if ($this->tDirectorateObjectives->removeElement($tDirectorateObjective)) {
            // set the owning side to null (unless already changed)
            if ($tDirectorateObjective->getFinancialYear() === $this) {
                $tDirectorateObjective->setFinancialYear(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TMilestones[]
     */
    public function getTMilestones(): Collection
    {
        return $this->tMilestones;
    }

    public function addTMilestone(TMilestones $tMilestone): self
    {
        if (!$this->tMilestones->contains($tMilestone)) {
            $this->tMilestones[] = $tMilestone;
            $tMilestone->setFinancialYear($this);
        }

        return $this;
    }

    public function removeTMilestone(TMilestones $tMilestone): self
    {
        if ($this->tMilestones->removeElement($tMilestone)) {
            // set the owning side to null (unless already changed)
            if ($tMilestone->getFinancialYear() === $this) {
                $tMilestone->setFinancialYear(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TAppraisals[]
     */
    public function getTAppraisals(): Collection
    {
        return $this->tAppraisals;
    }

    public function addTAppraisal(TAppraisals $tAppraisal): self
    {
        if (!$this->tAppraisals->contains($tAppraisal)) {
            $this->tAppraisals[] = $tAppraisal;
            $tAppraisal->setFinancialYear($this);
        }

        return $this;
    }

    public function removeTAppraisal(TAppraisals $tAppraisal): self
    {
        if ($this->tAppraisals->removeElement($tAppraisal)) {
            // set the owning side to null (unless already changed)
            if ($tAppraisal->getFinancialYear() === $this) {
                $tAppraisal->setFinancialYear(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TCountySectorsAdpProjects[]
     */
    public function getTCountySectorsAdpProjects(): Collection
    {
        return $this->tCountySectorsAdpProjects;
    }

    public function addTCountySectorsAdpProject(TCountySectorsAdpProjects $tCountySectorsAdpProject): self
    {
        if (!$this->tCountySectorsAdpProjects->contains($tCountySectorsAdpProject)) {
            $this->tCountySectorsAdpProjects[] = $tCountySectorsAdpProject;
            $tCountySectorsAdpProject->setFinancialYear($this);
        }

        return $this;
    }

    public function removeTCountySectorsAdpProject(TCountySectorsAdpProjects $tCountySectorsAdpProject): self
    {
        if ($this->tCountySectorsAdpProjects->removeElement($tCountySectorsAdpProject)) {
            // set the owning side to null (unless already changed)
            if ($tCountySectorsAdpProject->getFinancialYear() === $this) {
                $tCountySectorsAdpProject->setFinancialYear(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TCountyDepartmentsAdpProjects[]
     */
    public function getTCountyDepartmentsAdpProjects(): Collection
    {
        return $this->tCountyDepartmentsAdpProjects;
    }

    public function addTCountyDepartmentsAdpProject(TCountyDepartmentsAdpProjects $tCountyDepartmentsAdpProject): self
    {
        if (!$this->tCountyDepartmentsAdpProjects->contains($tCountyDepartmentsAdpProject)) {
            $this->tCountyDepartmentsAdpProjects[] = $tCountyDepartmentsAdpProject;
            $tCountyDepartmentsAdpProject->setFinancialYear($this);
        }

        return $this;
    }

    public function removeTCountyDepartmentsAdpProject(TCountyDepartmentsAdpProjects $tCountyDepartmentsAdpProject): self
    {
        if ($this->tCountyDepartmentsAdpProjects->removeElement($tCountyDepartmentsAdpProject)) {
            // set the owning side to null (unless already changed)
            if ($tCountyDepartmentsAdpProject->getFinancialYear() === $this) {
                $tCountyDepartmentsAdpProject->setFinancialYear(null);
            }
        }

        return $this;
    }

}
