<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TCountySectorsRepository;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_county_sectors:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_county_sectors:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TCountySectorsRepository::class)
 */

class TCountySectors
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_county_sectors:read", "t_county_sectors:write", "t_county_departments:read", "t_directorates:read", "t_appraisals:read", "t_cecs:read", "t_cos:read", "t_directors:read", "t_sector_objectives:read", "t_sector_priorities:read", "t_county_sectors_adp_projects:read", "t_directorates_adp_projects:read", "t_pcs:read" })
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({ "t_county_sectors:read", "t_county_sectors:write", "t_directorates:read", "t_sector_objectives:read", "t_directorate_objectives:read", "t_cecs:read", "t_county_departments:read", "t_sector_vision_and_missions:read", "t_responsibilities:read", "t_comments:read", "t_task_dependancies:read", "t_appraisals:read", "t_cos:read", "t_directors:read", "t_sector_priorities:read", "t_county_sectors_adp_projects:read", "t_directorates_adp_projects:read", "t_pcs:read" })
     */
    private $name;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_county_sectors:read", "t_county_sectors:write", "t_county_departments:read" })
     */
    private $code;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_county_sectors:read", "t_county_sectors:write", "t_directorates:read" })
     */
    private $alias;

    /**
     * @ORM\OneToMany(targetEntity=TDirectorateObjectives::class, mappedBy="sector")
     * @Groups({ "t_county_sectors:read", "t_county_sectors:write" })
     */
    private $tDirectorateObjectives;

    /**
     * @ORM\OneToMany(targetEntity=TDirectorates::class, mappedBy="sector")
     * @Groups({ "t_county_sectors:read", "t_county_sectors:write" })
     */
    private $tDirectorates;

    /**
     * @ORM\OneToMany(targetEntity=TSectorObjectives::class, mappedBy="sector")
     * @Groups({ "t_county_sectors:read", "t_county_sectors:write" })
     */
    private $tSectorObjectives;

    /**
     * @ORM\OneToMany(targetEntity=TCecs::class, mappedBy="sector")
     */
    private $tCecs;

    /**
     * @ORM\OneToMany(targetEntity=TCos::class, mappedBy="sector")
     */
    private $tCos;

    /**
     * @ORM\OneToMany(targetEntity=TCountyDepartments::class, mappedBy="sector")
     * @Groups({ "t_county_sectors:read", "t_county_sectors:write" })
     */
    private $tCountyDepartments;

    /**
     * @ORM\OneToMany(targetEntity=TSectorVisionAndMissions::class, mappedBy="sector")
     */
    private $tSectorVisionAndMissions;

    /**
     * @ORM\OneToMany(targetEntity=TResponsibilities::class, mappedBy="sector")
     */
    private $tResponsibilities;

    /**
     * @ORM\OneToMany(targetEntity=TComments::class, mappedBy="sector")
     */
    private $tComments;

    /**
     * @ORM\OneToMany(targetEntity=TMilestones::class, mappedBy="sector")
     */
    private $tMilestones;

    /**
     * @ORM\OneToMany(targetEntity=TTaskDependancies::class, mappedBy="taskOnwerSector")
     */
    private $tTaskDependancies;

    /**
     * @ORM\OneToMany(targetEntity=TAppraisals::class, mappedBy="sector")
     */
    private $tAppraisals;

    /**
     * @ORM\OneToMany(targetEntity=TDirectors::class, mappedBy="sector")
     */
    private $tDirectors;

    /**
     * @ORM\OneToMany(targetEntity=TSectorPriorities::class, mappedBy="sector")
     */
    private $tSectorPriorities;

    /**
     * @ORM\OneToMany(targetEntity=TCidps::class, mappedBy="sector")
     */
    private $tCidps;

    /**
     * @ORM\ManyToOne(targetEntity=TGovernorOffices::class, inversedBy="tCountySectors")
     * @Groups({ "t_county_sectors:read", "t_county_sectors:write" })
     */
    private $governorOffice;

    /**
     * @ORM\OneToMany(targetEntity=TSectorStrategies::class, mappedBy="sector")
     */
    private $tSectorStrategies;

    /**
     * @ORM\OneToMany(targetEntity=TCountySectorsAdpProjects::class, mappedBy="sector")
     * @Groups({ "t_county_sectors:read", "t_county_sectors:write" })
     */
    private $tCountySectorsAdpProjects;

    /**
     * @ORM\OneToMany(targetEntity=TCountyDepartmentsAdpProjects::class, mappedBy="sector")
     * @Groups({ "t_county_sectors:read", "t_county_sectors:write" })
     */
    private $tCountyDepartmentsAdpProjects;

    /**
     * @ORM\OneToMany(targetEntity=TProjectLocationMaps::class, mappedBy="sector")
     */
    private $tProjectLocationMaps;

    public function __construct()
    {
        $this->tDirectorateObjectives = new ArrayCollection();
        $this->tDirectorates = new ArrayCollection();
        $this->tSectorObjectives = new ArrayCollection();
        $this->tCecs = new ArrayCollection();
        $this->tCos = new ArrayCollection();
        $this->tCountySections = new ArrayCollection();
        $this->tSectorVisionAndMissions = new ArrayCollection();
        $this->tResponsibilities = new ArrayCollection();
        $this->tComments = new ArrayCollection();
        $this->tMilestones = new ArrayCollection();
        $this->tTaskDependancies = new ArrayCollection();
        $this->tAppraisals = new ArrayCollection();
        $this->tDirectors = new ArrayCollection();
        $this->tSectorPriorities = new ArrayCollection();
        $this->tCidps = new ArrayCollection();
        $this->tSectorStrategies = new ArrayCollection();
        $this->tCountySectorsAdpProjects = new ArrayCollection();
        $this->tCountyDepartmentsAdpProjects = new ArrayCollection();
        $this->tProjectLocationMaps = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getCode(): ?string
    {
        return $this->code;
    }

    public function setCode(?string $code): self
    {
        $this->code = $code;

        return $this;
    }

    public function getAlias(): ?string
    {
        return $this->alias;
    }

    public function setAlias(?string $alias): self
    {
        $this->alias = $alias;

        return $this;
    }

    /**
     * @return Collection|TDirectorateObjectives[]
     */
    public function getTDirectorateObjectives(): Collection
    {
        return $this->tDirectorateObjectives;
    }

    public function addTDirectorateObjective(TDirectorateObjectives $tDirectorateObjective): self
    {
        if (!$this->tDirectorateObjectives->contains($tDirectorateObjective)) {
            $this->tDirectorateObjectives[] = $tDirectorateObjective;
            $tDirectorateObjective->setSector($this);
        }

        return $this;
    }

    public function removeTDirectorateObjective(TDirectorateObjectives $tDirectorateObjective): self
    {
        if ($this->tDirectorateObjectives->removeElement($tDirectorateObjective)) {
            // set the owning side to null (unless already changed)
            if ($tDirectorateObjective->getSector() === $this) {
                $tDirectorateObjective->setSector(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TDirectorates[]
     */
    public function getTDirectorates(): Collection
    {
        return $this->tDirectorates;
    }

    public function addTDirectorate(TDirectorates $tDirectorate): self
    {
        if (!$this->tDirectorates->contains($tDirectorate)) {
            $this->tDirectorates[] = $tDirectorate;
            $tDirectorate->setSector($this);
        }

        return $this;
    }

    public function removeTDirectorate(TDirectorates $tDirectorate): self
    {
        if ($this->tDirectorates->removeElement($tDirectorate)) {
            // set the owning side to null (unless already changed)
            if ($tDirectorate->getSector() === $this) {
                $tDirectorate->setSector(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TSectorObjectives[]
     */
    public function getTSectorObjectives(): Collection
    {
        return $this->tSectorObjectives;
    }

    public function addTSectorObjective(TSectorObjectives $tSectorObjective): self
    {
        if (!$this->tSectorObjectives->contains($tSectorObjective)) {
            $this->tSectorObjectives[] = $tSectorObjective;
            $tSectorObjective->setSector($this);
        }

        return $this;
    }

    public function removeTSectorObjective(TSectorObjectives $tSectorObjective): self
    {
        if ($this->tSectorObjectives->removeElement($tSectorObjective)) {
            // set the owning side to null (unless already changed)
            if ($tSectorObjective->getSector() === $this) {
                $tSectorObjective->setSector(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TCecs[]
     */
    public function getTCecs(): Collection
    {
        return $this->tCecs;
    }

    public function addTCec(TCecs $tCec): self
    {
        if (!$this->tCecs->contains($tCec)) {
            $this->tCecs[] = $tCec;
            $tCec->setSector($this);
        }

        return $this;
    }

    public function removeTCec(TCecs $tCec): self
    {
        if ($this->tCecs->removeElement($tCec)) {
            // set the owning side to null (unless already changed)
            if ($tCec->getSector() === $this) {
                $tCec->setSector(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TCos[]
     */
    public function getTCos(): Collection
    {
        return $this->tCos;
    }

    public function addTCo(TCos $tCo): self
    {
        if (!$this->tCos->contains($tCo)) {
            $this->tCos[] = $tCo;
            $tCo->setSector($this);
        }

        return $this;
    }

    public function removeTCo(TCos $tCo): self
    {
        if ($this->tCos->removeElement($tCo)) {
            // set the owning side to null (unless already changed)
            if ($tCo->getSector() === $this) {
                $tCo->setSector(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TCountyDepartments[]
     */
    public function getTCountyDepartments(): Collection
    {
        return $this->tCountyDepartments;
    }

    public function addTCountyDepartments(TCountyDepartments $tCountyDepartments): self
    {
        if (!$this->tCountyDepartments->contains($tCountyDepartments)) {
            $this->tCountyDepartments[] = $tCountyDepartments;
            $tCountyDepartments->setSector($this);
        }

        return $this;
    }

    public function removeTCountyDepartments(TCountyDepartments $tCountyDepartments): self
    {
        if ($this->tCountyDepartments->removeElement($tCountyDepartments)) {
            // set the owning side to null (unless already changed)
            if ($tCountyDepartments->getSector() === $this) {
                $tCountyDepartments->setSector(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TSectorVisionAndMissions[]
     */
    public function getTSectorVisionAndMissions(): Collection
    {
        return $this->tSectorVisionAndMissions;
    }

    public function addTSectorVisionAndMission(TSectorVisionAndMissions $tSectorVisionAndMission): self
    {
        if (!$this->tSectorVisionAndMissions->contains($tSectorVisionAndMission)) {
            $this->tSectorVisionAndMissions[] = $tSectorVisionAndMission;
            $tSectorVisionAndMission->setSector($this);
        }

        return $this;
    }

    public function removeTSectorVisionAndMission(TSectorVisionAndMissions $tSectorVisionAndMission): self
    {
        if ($this->tSectorVisionAndMissions->removeElement($tSectorVisionAndMission)) {
            // set the owning side to null (unless already changed)
            if ($tSectorVisionAndMission->getSector() === $this) {
                $tSectorVisionAndMission->setSector(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TResponsibilities[]
     */
    public function getTResponsibilities(): Collection
    {
        return $this->tResponsibilities;
    }

    public function addTResponsibility(TResponsibilities $tResponsibility): self
    {
        if (!$this->tResponsibilities->contains($tResponsibility)) {
            $this->tResponsibilities[] = $tResponsibility;
            $tResponsibility->setSector($this);
        }

        return $this;
    }

    public function removeTResponsibility(TResponsibilities $tResponsibility): self
    {
        if ($this->tResponsibilities->removeElement($tResponsibility)) {
            // set the owning side to null (unless already changed)
            if ($tResponsibility->getSector() === $this) {
                $tResponsibility->setSector(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TComments[]
     */
    public function getTComments(): Collection
    {
        return $this->tComments;
    }

    public function addTComment(TComments $tComment): self
    {
        if (!$this->tComments->contains($tComment)) {
            $this->tComments[] = $tComment;
            $tComment->setSector($this);
        }

        return $this;
    }

    public function removeTComment(TComments $tComment): self
    {
        if ($this->tComments->removeElement($tComment)) {
            // set the owning side to null (unless already changed)
            if ($tComment->getSector() === $this) {
                $tComment->setSector(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TMilestones[]
     */
    public function getTMilestones(): Collection
    {
        return $this->tMilestones;
    }

    public function addTMilestone(TMilestones $tMilestone): self
    {
        if (!$this->tMilestones->contains($tMilestone)) {
            $this->tMilestones[] = $tMilestone;
            $tMilestone->setSector($this);
        }

        return $this;
    }

    public function removeTMilestone(TMilestones $tMilestone): self
    {
        if ($this->tMilestones->removeElement($tMilestone)) {
            // set the owning side to null (unless already changed)
            if ($tMilestone->getSector() === $this) {
                $tMilestone->setSector(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TTaskDependancies[]
     */
    public function getTTaskDependancies(): Collection
    {
        return $this->tTaskDependancies;
    }

    public function addTTaskDependancy(TTaskDependancies $tTaskDependancy): self
    {
        if (!$this->tTaskDependancies->contains($tTaskDependancy)) {
            $this->tTaskDependancies[] = $tTaskDependancy;
            $tTaskDependancy->setTaskOnwerSector($this);
        }

        return $this;
    }

    public function removeTTaskDependancy(TTaskDependancies $tTaskDependancy): self
    {
        if ($this->tTaskDependancies->removeElement($tTaskDependancy)) {
            // set the owning side to null (unless already changed)
            if ($tTaskDependancy->getTaskOnwerSector() === $this) {
                $tTaskDependancy->setTaskOnwerSector(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TAppraisals[]
     */
    public function getTAppraisals(): Collection
    {
        return $this->tAppraisals;
    }

    public function addTAppraisal(TAppraisals $tAppraisal): self
    {
        if (!$this->tAppraisals->contains($tAppraisal)) {
            $this->tAppraisals[] = $tAppraisal;
            $tAppraisal->setSector($this);
        }

        return $this;
    }

    public function removeTAppraisal(TAppraisals $tAppraisal): self
    {
        if ($this->tAppraisals->removeElement($tAppraisal)) {
            // set the owning side to null (unless already changed)
            if ($tAppraisal->getSector() === $this) {
                $tAppraisal->setSector(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TDirectors[]
     */
    public function getTDirectors(): Collection
    {
        return $this->tDirectors;
    }

    public function addTDirector(TDirectors $tDirector): self
    {
        if (!$this->tDirectors->contains($tDirector)) {
            $this->tDirectors[] = $tDirector;
            $tDirector->setSector($this);
        }

        return $this;
    }

    public function removeTDirector(TDirectors $tDirector): self
    {
        if ($this->tDirectors->removeElement($tDirector)) {
            // set the owning side to null (unless already changed)
            if ($tDirector->getSector() === $this) {
                $tDirector->setSector(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TSectorPriorities[]
     */
    public function getTSectorPriorities(): Collection
    {
        return $this->tSectorPriorities;
    }

    public function addTSectorPriority(TSectorPriorities $tSectorPriority): self
    {
        if (!$this->tSectorPriorities->contains($tSectorPriority)) {
            $this->tSectorPriorities[] = $tSectorPriority;
            $tSectorPriority->setSector($this);
        }

        return $this;
    }

    public function removeTSectorPriority(TSectorPriorities $tSectorPriority): self
    {
        if ($this->tSectorPriorities->removeElement($tSectorPriority)) {
            // set the owning side to null (unless already changed)
            if ($tSectorPriority->getSector() === $this) {
                $tSectorPriority->setSector(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TCidps[]
     */
    public function getTCidps(): Collection
    {
        return $this->tCidps;
    }

    public function addTCidp(TCidps $tCidp): self
    {
        if (!$this->tCidps->contains($tCidp)) {
            $this->tCidps[] = $tCidp;
            $tCidp->setSector($this);
        }

        return $this;
    }

    public function removeTCidp(TCidps $tCidp): self
    {
        if ($this->tCidps->removeElement($tCidp)) {
            // set the owning side to null (unless already changed)
            if ($tCidp->getSector() === $this) {
                $tCidp->setSector(null);
            }
        }

        return $this;
    }

    public function getGovernorOffice(): ?TGovernorOffices
    {
        return $this->governorOffice;
    }

    public function setGovernorOffice(?TGovernorOffices $governorOffice): self
    {
        $this->governorOffice = $governorOffice;

        return $this;
    }

    /**
     * @return Collection|TSectorStrategies[]
     */
    public function getTSectorStrategies(): Collection
    {
        return $this->tSectorStrategies;
    }

    public function addTSectorStrategy(TSectorStrategies $tSectorStrategy): self
    {
        if (!$this->tSectorStrategies->contains($tSectorStrategy)) {
            $this->tSectorStrategies[] = $tSectorStrategy;
            $tSectorStrategy->setSector($this);
        }

        return $this;
    }

    public function removeTSectorStrategy(TSectorStrategies $tSectorStrategy): self
    {
        if ($this->tSectorStrategies->removeElement($tSectorStrategy)) {
            // set the owning side to null (unless already changed)
            if ($tSectorStrategy->getSector() === $this) {
                $tSectorStrategy->setSector(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TCountySectorsAdpProjects[]
     */
    public function getTCountySectorsAdpProjects(): Collection
    {
        return $this->tCountySectorsAdpProjects;
    }

    public function addTCountySectorsAdpProject(TCountySectorsAdpProjects $tCountySectorsAdpProject): self
    {
        if (!$this->tCountySectorsAdpProjects->contains($tCountySectorsAdpProject)) {
            $this->tCountySectorsAdpProjects[] = $tCountySectorsAdpProject;
            $tCountySectorsAdpProject->setSector($this);
        }

        return $this;
    }

    public function removeTCountySectorsAdpProject(TCountySectorsAdpProjects $tCountySectorsAdpProject): self
    {
        if ($this->tCountySectorsAdpProjects->removeElement($tCountySectorsAdpProject)) {
            // set the owning side to null (unless already changed)
            if ($tCountySectorsAdpProject->getSector() === $this) {
                $tCountySectorsAdpProject->setSector(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TCountyDepartmentsAdpProjects[]
     */
    public function getTCountyDepartmentsAdpProjects(): Collection
    {
        return $this->tCountyDepartmentsAdpProjects;
    }

    public function addTCountyDepartmentsAdpProject(TCountyDepartmentsAdpProjects $tCountyDepartmentsAdpProject): self
    {
        if (!$this->tCountyDepartmentsAdpProjects->contains($tCountyDepartmentsAdpProject)) {
            $this->tCountyDepartmentsAdpProjects[] = $tCountyDepartmentsAdpProject;
            $tCountyDepartmentsAdpProject->setSector($this);
        }

        return $this;
    }

    public function removeTCountyDepartmentsAdpProject(TCountyDepartmentsAdpProjects $tCountyDepartmentsAdpProject): self
    {
        if ($this->tCountyDepartmentsAdpProjects->removeElement($tCountyDepartmentsAdpProject)) {
            // set the owning side to null (unless already changed)
            if ($tCountyDepartmentsAdpProject->getSector() === $this) {
                $tCountyDepartmentsAdpProject->setSector(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TProjectLocationMaps[]
     */
    public function getTProjectLocationMaps(): Collection
    {
        return $this->tProjectLocationMaps;
    }

    public function addTProjectLocationMap(TProjectLocationMaps $tProjectLocationMap): self
    {
        if (!$this->tProjectLocationMaps->contains($tProjectLocationMap)) {
            $this->tProjectLocationMaps[] = $tProjectLocationMap;
            $tProjectLocationMap->setSector($this);
        }

        return $this;
    }

    public function removeTProjectLocationMap(TProjectLocationMaps $tProjectLocationMap): self
    {
        if ($this->tProjectLocationMaps->removeElement($tProjectLocationMap)) {
            // set the owning side to null (unless already changed)
            if ($tProjectLocationMap->getSector() === $this) {
                $tProjectLocationMap->setSector(null);
            }
        }

        return $this;
    }

    
}
