<?php

namespace App\Controller;

use App\Entity\User;
use App\Entity\TGroups;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use App\Repository\TGroupsRepository;
use App\Repository\UserRepository;

use Symfony\Component\Security\Core\Encoder\UserPasswordEncoderInterface;

use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Serializer\Encoder\JsonEncoder;

class AuthController extends AbstractController
{

    /** @var UserRepository $userRepository */
    private $userRepository;

    /** UserPasswordEncoderInterface $encoder */
    private $encoder;

    /**
     * AuthController Constructor
     *
     * @param UserRepository $userRepository*
     * @param tgroupsRepository $userRepository
     * @param UserPasswordEncoderInterface $encoder
    */
    public function __construct(UserRepository $userRepository, TGroupsRepository $tgroupsRepository, UserPasswordEncoderInterface $encoder)
    {
        $this->userRepository = $userRepository;
        $this->tgroupsRepository = $tgroupsRepository;
        $this->encoder = $encoder;
    }

    /**
    * api route redirects
    * @return Response
    */
    public function api()
    {
        return new Response(sprintf("Logged in as %s", $this->getUser()->getUsername()));
    }

    /**
     * Login new user
     * @param Request $request
     * @Route("/api/login_check", methods={"GET","POST"})
     * @return Response
     */
    public function login(Request $request)
    {
        return new Response(sprintf('User %s successfully created', $request->get('email')));
    }

     /**
     * Login new user
     * @param Request $request
     * @Route("/usergroup", methods={"GET", "POST"} , name="usergroup")
     * @return Response
     */
    public function usergroup(Request $request)
    {
        $myGroupId = 0;
        $entityManager = $this->getDoctrine()->getManager();
        $query = $entityManager->createQuery("SELECT u.groupId FROM App\Entity\User u WHERE u.email = '" . $request->get('email') . "'");
        $myGroupId = $query->getSingleScalarResult();
        //return new JsonResponse({"group" : $myGroupId});
        return new Response($myGroupId);
    }

     /**
     * Get users list
     * @param Request $request
     * @Route("/getusers", methods={"GET"})
     * @return Response
     */
    public function getusers(Request $request)
    {
        $arrayCollection = array();
        $myNum = 1;
        $dataGroup = $this->getDoctrine()->getRepository(TGroups::class)->findAll();
                foreach($dataGroup as $itemGroup) {

                $data = $this->getDoctrine()->getRepository(user::class)->findBy(array('groupId'=>$itemGroup->getId()));
                foreach($data as $item) {
                    if($item->getId() > 0){

                        $arrayCollection[] = array(
                            'groupName' => $itemGroup->getGroupName(),
                                 'type' => $itemGroup->getType(),
                                'my_no' => $myNum,
                                   'id' => $item->getId(),
                                'email' => $item->getEmail(),
                              'phoneNo' => $item->getPhoneNo(),
                               'status' => $item->getStatus()
                        );
                        $myNum = $myNum + 1;
                    }
                }
            }

        return new JsonResponse($arrayCollection);

    }

     /**
     * Login new user
     * @param Request $request
     * @Route("/deleteuser/{id}", methods={"DELETE"} , name="deleteuser")
     * @return Response
     */
    public function deletetheuser(Request $request, $id)
    {
        $myGroupId = 0;
        $entityManager = $this->getDoctrine()->getManager();
        $query = $entityManager->createQuery("DELETE FROM App\Entity\User u WHERE u.id = " . $id . "");
        $myGroupId = $query->getSingleScalarResult();

        $arr[] = array(
            'info' => 'Deleted successfully!'
        );
        return new JsonResponse($arr);
    }

    /**
     * Get users list
     * @param Request $request
     * @Route("/userbyparent/{id}", methods={"GET"})
     * @return Response
     */
    public function getUserByParentId(Request $request, $id): Response
    {
        $myGroupNem = '';

        $arr = array();

        $entityManagerU = $this->getDoctrine()->getManager();
        $queryU = $entityManagerU->createQuery("SELECT u.id AS id, u.groupId AS groupId, u.email AS email, u.phoneNo AS phoneNo, u.status AS mystatus FROM App\Entity\User u WHERE u.parentId = " . $id . "");
        $myUserDetails = $queryU->getScalarResult();

        $entityManagerG = $this->getDoctrine()->getManager();
        $queryG = $entityManagerG->createQuery("SELECT u.groupName FROM App\Entity\TGroups u WHERE u.id = " . $myUserDetails[0]['groupId'] . "");
        $myGroupNem = $queryG->getSingleScalarResult();

        $arr[] = array(
                    'id' => $myUserDetails[0]['id'],
             'groupName' => $myGroupNem,
                 'email' => $myUserDetails[0]['email'],
               'phoneNo' => $myUserDetails[0]['phoneNo'],
                'status' => $myUserDetails[0]['mystatus']
        );

        return new JsonResponse($arr);
    }

        /**
     * Get users list
     * @param Request $request
     * @Route("/userbystaff/{id}", methods={"GET"})
     * @return Response
     */
    public function userbystaff(Request $request, $id): Response
    {
        $myGroupNem = '';

        $arr = array();

        $entityManagerU = $this->getDoctrine()->getManager();
        $queryU = $entityManagerU->createQuery("SELECT u.id AS id, u.groupId AS groupId, u.email AS email, u.phoneNo AS phoneNo, u.status AS mystatus FROM App\Entity\User u WHERE u.staffId = " . $id . "");
        $myUserDetails = $queryU->getScalarResult();

        if($myUserDetails){

        $entityManagerG = $this->getDoctrine()->getManager();
        $queryG = $entityManagerG->createQuery("SELECT u.groupName FROM App\Entity\TGroups u WHERE u.id = " . $myUserDetails[0]['groupId'] . "");
        $myGroupNem = $queryG->getSingleScalarResult();

        $arr[] = array(
                        'id' => $myUserDetails[0]['id'],
                 'groupName' => $myGroupNem,
                     'email' => $myUserDetails[0]['email'],
                   'phoneNo' => $myUserDetails[0]['phoneNo'],
                    'status' => $myUserDetails[0]['mystatus']
        );
        }

        return new JsonResponse($arr);
    }

    /**
     * Get users list
     * @param Request $request
     * @Route("/userbyparent/{id}", methods={"GET"})
     * @return Response
     */
    public function userbyparent(Request $request, $id): Response
    {
        $myGroupNem = '';

        $arr = array();

        $entityManagerU = $this->getDoctrine()->getManager();
        $queryU = $entityManagerU->createQuery("SELECT u.id AS id, u.groupId AS groupId, u.email AS email, u.phoneNo AS phoneNo, u.status AS mystatus FROM App\Entity\User u WHERE u.parentId = " . $id . "");
        $myUserDetails = $queryU->getScalarResult();

        if($myUserDetails){

        $entityManagerG = $this->getDoctrine()->getManager();
        $queryG = $entityManagerG->createQuery("SELECT u.groupName FROM App\Entity\TGroups u WHERE u.id = " . $myUserDetails[0]['groupId'] . "");
        $myGroupNem = $queryG->getSingleScalarResult();

        $arr[] = array(
                        'id' => $myUserDetails[0]['id'],
                 'groupName' => $myGroupNem,
                     'email' => $myUserDetails[0]['email'],
                   'phoneNo' => $myUserDetails[0]['phoneNo'],
                    'status' => $myUserDetails[0]['mystatus']
        );
        }

        return new JsonResponse($arr);
    }

    /**
     * Get users list
     * @param Request $request
     * @Route("/userbyemail", methods={"GET"})
     * @return Response
     */
    public function userbyemail(Request $request): Response
    {
        $myStaff = '';
        $arr = array();
        $entityManagerG = $this->getDoctrine()->getManager();
        $queryG = $entityManagerG->createQuery("SELECT u.groupId, u.id, u.phoneNo, u.staffId FROM App\Entity\User u WHERE u.email = '" . $request->get('email') . "'");
        $myStaff = $queryG->getScalarResult();

        $arr[] = array(
            'groupId' => $myStaff[0]['groupId'],
                 'id' => $myStaff[0]['id'],
            'phoneNo' => $myStaff[0]['phoneNo'],
            'staffId' => $myStaff[0]['staffId']
        );

        return new JsonResponse($arr);

    }

     /**
     * Get users list
     * @param Request $request
     * @Route("/staffbyemail", methods={"GET"})
     * @return Response
     */
    public function staffbyemail(Request $request): Response
    {

        $myStaff = '';
        $arr = array();
        $entityManagerG = $this->getDoctrine()->getManager();
        $queryG = $entityManagerG->createQuery("SELECT u.phoneNo, u.staffId FROM App\Entity\User u WHERE u.email = '" . $request->get('email') . "'");
        $myStaff = $queryG->getScalarResult();

        $arr[] = array(
              'phoneNo' => $myStaff[0]['phoneNo'],
              'staffId' => $myStaff[0]['staffId']
        );

        return new JsonResponse($arr);

    }


    /**
     * Get users list
     * @param Request $request
     * @Route("/parentbyemail", methods={"GET"})
     * @return Response
     */
    public function parentbyemail(Request $request): Response
    {
        $myParent = '';
        $arr = array();
        $entityManagerG = $this->getDoctrine()->getManager();
        $queryG = $entityManagerG->createQuery("SELECT u.phoneNo, u.parentId FROM App\Entity\User u WHERE u.email = '" . $request->get('email') . "'");
        $myParent = $queryG->getScalarResult();

        $arr[] = array(
             'phoneNo' => $myParent[0]['phoneNo'],
            'parentId' => $myParent[0]['parentId']
        );

        return new JsonResponse($arr);

    }

    /**
     * Get users list
     * @param Request $request
     * @Route("/userbyid/{id}", methods={"GET"})
     * @return Response
     */
    public function userbyid(Request $request, $id): Response
    {
        $myStaff = '';
        $arr = array();
        $entityManagerG = $this->getDoctrine()->getManager();
        $queryG = $entityManagerG->createQuery("SELECT u.groupId, u.id, u.phoneNo, u.email, u.status FROM App\Entity\User u WHERE u.id = " . $id . "");
        $myStaff = $queryG->getScalarResult();

        $arr[] = array(
            'groupId' => $myStaff[0]['groupId'],
                 'id' => $myStaff[0]['id'],
            'phoneNo' => $myStaff[0]['phoneNo'],
              'email' => $myStaff[0]['email'],
             'status' => $myStaff[0]['status']
        );

        return new JsonResponse($arr);

    }

    /**
     * Update user
     * @param Request $request
     * @Route("/updateuser/{id}", methods={"PATCH"})
     * @return Response
     */
    public function updateuser($id, Request $request)
    {

        $content = json_decode($request->getContent(), true);

        $user = new User();
        $encoded = $this->encoder->encodePassword($user, $content['password']);

        $myGroupId = 0;
        $entityManager = $this->getDoctrine()->getManager();
        $query = $entityManager->createQuery("UPDATE App\Entity\User u SET u.groupId = " . $content['groupId'] . ", u.email = '" . $content['email'] . "',u.password = '" . $encoded . "',u.phoneNo = '" . $content['phoneNo'] . "',u.staffId = " . $content['staffId'] . ", u.status = '" . $content['status'] . "' WHERE u.id = " . $id . "");
        $myGroupId = $query->getSingleScalarResult();

        return new Response($myGroupId);

    }


    /**
     * Register new user
     * @param Request $request
     * @Route("/register", methods={"GET","POST"})
     * @return Response
     */
    public function register(Request $request)
    {
        $content = json_decode($request->getContent(), true);

        //$groupId = $this->tgroupsRepository->findByGroupId($content['groupId']);

        $user = new User();
        $user->setEmail($content['email']);

        $encoded = $this->encoder->encodePassword($user, $content['password']);
        $user->setPassword($encoded);

        $user->setGroupId($content['groupId']);
        $user->setPhoneNo($content['phoneNo']);
        $user->setStatus($content['status']);

        if($content['staffId'] > 0){
            $user->setStaffId($content['staffId']);
        }
        if($content['parentId'] > 0){
            $user->setParentId($content['parentId']);
        }
        $entityManager = $this->getDoctrine()->getManager();
        $entityManager->persist($user);
        $entityManager->flush();

        // return new Response(json_encode("email": $content['email']));
        $userId = $user->getId();

        return new Response(sprintf($userId));
    }

    /**
     * @Route("/auth", name="auth")
     */
    public function index(): Response
    {
        return $this->render('auth/index.html.twig', [
            'controller_name' => 'AuthController',
        ]);
    }
}
